<?php  
/* 
Plugin Name: VC Animated Gradient Background
Version: 1.1
Author: Boom-Apps
Author URI: http://codecanyon.net/user/boom-apps
Description: Animated gradient background for Visual Composer row
*/  

class VC_AnimatedGradient {
	
	
	function backendElement() {
		vc_map( array(
            "name" => __("VC Animated Gradient Background", 'vc_extend'),
            "description" => __("Creative backgrounds!", 'vc_extend'),
            "base" => "vc_animatedgradient",
            "class" => "",
            "controls" => "full",
			"params" => array(
              array("save_always" => true, "type" => "textarea", "holder" => "div", "class" => "", "heading" => "Id - unique per page", "param_name" => "theid", "value" => "vcanimatedgradient_".time()."_".rand(100000,999999999) ),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Cycle duration", "param_name" => "duration", "value" => "3000", "description" => "In miliseconds" ),
              array("save_always" => true, "type" => "dropdown", "class" => "", "heading" => "Gradient direction", "param_name" => "direction", "value" => array("Top to bottom" =>"topbottom", "Left to right" => "leftright", "Top left top right bottom" => "topleftrightbottom", "Top right to left bottom" => "toprightleftbottom") ),
			  
			  array("save_always" => true, "group" => "Colors", "type" => "dropdown", "class" => "", "heading" => "Stops count", "param_name" => "stopscount", "value" => array("2","3","4","5","6","7")),
			  array("dependency" => array("element" => "stopscount", "value" => array("2","3","4","5","6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 1 color A", "param_name" => "stop1colora", "value" => "#000000"),
			  array("dependency" => array("element" => "stopscount", "value" => array("2","3","4","5","6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 1 color B", "param_name" => "stop1colorb", "value" => "#FFFFFF"),
			  array("dependency" => array("element" => "stopscount", "value" => array("2","3","4","5","6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 2 color A", "param_name" => "stop2colora", "value" => "#FFFFFF"),
			  array("dependency" => array("element" => "stopscount", "value" => array("2","3","4","5","6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 2 color B", "param_name" => "stop2colorb", "value" => "#000000"),
			  array("dependency" => array("element" => "stopscount", "value" => array("3","4","5","6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 3 color A", "param_name" => "stop3colora", "value" => "#000000"),
			  array("dependency" => array("element" => "stopscount", "value" => array("3","4","5","6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 3 color B", "param_name" => "stop3colorb", "value" => "#FFFFFF"),
			  array("dependency" => array("element" => "stopscount", "value" => array("4","5","6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 4 color A", "param_name" => "stop4colora", "value" => "#FFFFFF"),
			  array("dependency" => array("element" => "stopscount", "value" => array("4","5","6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 4 color B", "param_name" => "stop4colorb", "value" => "#000000"),
			  array("dependency" => array("element" => "stopscount", "value" => array("5","6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 5 color A", "param_name" => "stop5colora", "value" => "#000000"),
			  array("dependency" => array("element" => "stopscount", "value" => array("5","6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 5 color B", "param_name" => "stop5colorb", "value" => "#FFFFFF"),
			  array("dependency" => array("element" => "stopscount", "value" => array("6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 6 color A", "param_name" => "stop6colora", "value" => "#FFFFFF"),
			  array("dependency" => array("element" => "stopscount", "value" => array("6","7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 6 color B", "param_name" => "stop6colorb", "value" => "#000000"),
			  array("dependency" => array("element" => "stopscount", "value" => array("7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 7 color A", "param_name" => "stop7colora", "value" => "#000000"),
			  array("dependency" => array("element" => "stopscount", "value" => array("7","8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 7 color B", "param_name" => "stop8colorb", "value" => "#FFFFFF"),
			  array("dependency" => array("element" => "stopscount", "value" => array("8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 8 color A", "param_name" => "stop9colora", "value" => "#FFFFFF"),
			  array("dependency" => array("element" => "stopscount", "value" => array("8")), "save_always" => true, "group" => "Colors", "type" => "colorpicker", "class" => "", "heading" => "Stop 8 color B", "param_name" => "stop9colorb", "value" => "#000000")
			)
			
			
        ) );
		 
	}
	function theShortcode($Atts, $Content = null) {
		wp_enqueue_script(  array( 'jquery','animatedcanvasgradient','vc_animatedgradient' ) );
		wp_enqueue_style(  array( 'vc_animatedgradient' ) );
		
		$StopAColor = "[";
		for ($i = 1; $i<=$Atts['stopscount']; $i++) {
			$HEX = self::convertColors($Atts['stop'.$i.'colora']);
			$StopAColor .= '{"r":"' . $HEX['red'] . '","g":"' . $HEX['green'] . '","b":"' .$HEX['blue'] . '"},';
		}
		$StopAColor .= "]";
		$StopAColor = str_replace(",]","]",$StopAColor);
		
		$StopBColor = "[";
		for ($i = 1; $i<=$Atts['stopscount']; $i++) {
			$HEX = self::convertColors($Atts['stop'.$i.'colorb']);
			$StopBColor .= '{"r":"' . $HEX['red'] . '","g":"' . $HEX['green'] . '","b":"' .$HEX['blue'] . '"},'; 
		}
		$StopBColor .= "]";
		$StopBColor = str_replace(",]","]",$StopBColor);
		
		
		$Return = '<div id="'.$Atts['theid'].'" class="vc-animatedgradient-background" ';
		$Return .= 'data-duration= "'.$Atts['duration'].'" ';
		$Return .= 'data-direction= "'.$Atts['direction'].'" ';
		$Return .= 'data-theid= "'.$Atts['theid'].'" ';
		$Return .= "data-stopacolor='".$StopAColor."' ";
		$Return .= "data-stopbcolor='".$StopBColor."' ";
		$Return .= 'style="display:none;"></div>';
		
		return $Return;
	}
	
	
	function custom_css_classes_for_vc_row_and_vc_column( $class_string, $tag ) {
	  if ( $tag == 'vc_row' || $tag == 'vc_row_inner' ) {
		if (strpos($class_string,'boomapps_vcrow') == false) { $class_string = $class_string . " boomapps_vcrow"; } 
	  }
	  if ( $tag == 'vc_column' || $tag == 'vc_column_inner' ) {
		if (strpos($class_string,'boomapps_vccolumn') == false) { $class_string = $class_string . " boomapps_vccolumn"; }
	  }
	  return $class_string; 
	}
	
	
	function convertColors($hexStr, $returnAsString = false, $seperator = ',') {
		$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
		$rgbArray = array();
		if (strlen($hexStr) == 6) { //If a proper hex code, convert using bitwise operation. No overhead... faster
			$colorVal = hexdec($hexStr);
			$rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
			$rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
			$rgbArray['blue'] = 0xFF & $colorVal;
		} elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
			$rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
			$rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
			$rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
		} else {
			return false; //Invalid hex color code
		}
		return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
	} 
	
	
	function registerStuff() {
		add_shortcode( 'vc_animatedgradient', array($this,'theShortcode') );	
		$this->backendElement();		
	}
	function registerScripts() {
		 wp_register_script( 'vc_animatedgradient', plugins_url('vcanimatedgradient.js',__FILE__ ) );
		 wp_register_style( 'vc_animatedgradient', plugins_url('vcanimatedgradient.css',__FILE__ ) );
		 wp_register_script( 'animatedcanvasgradient', plugins_url('_3rdparty/animatedcanvasgradient.js',__FILE__ ) );
		
	}
	function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'registerScripts') );
		add_action( 'init', array( $this, 'registerStuff') );	
		add_filter( 'vc_shortcodes_css_class', array($this,'custom_css_classes_for_vc_row_and_vc_column'), 10, 2 );
	}
}


/* Let's go! */
if (function_exists('vc_map')) {
	new VC_AnimatedGradient;
}

